#ifndef __ExpStdDefines__
#define __ExpStdDefines__

/**
 * @file StdDefines.h
 * @brief Generic defines
 *
 * Defines lots of handy stuff, that is available to all classes that inherit from CCountedObject by default
 *
 * @date 21/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: StdDefines.h,v 1.6 2007/03/07 22:54:14 paul Exp $
 */

#include "StdIncludes.h"

//	===========================================================================

/**
 * @def NULL_POINTER(x)
 * Sets x = NULL
 */
#define NULL_POINTER(x) (x) = NULL;

/**
 * @def FREE_POINTER(x)
 * Sets Deletes x and sets it to NULL
 */
#define FREE_POINTER(x) if(x) { delete (x); }	 (x) = NULL;

/**
 * @def FREE_ARRAY_POINTER(x)
 * Sets Deletes the array pointed at to by x and sets it to NULL
 */
#define FREE_ARRAY_POINTER(x) if(x) { delete [] (x); } (x) = NULL;

//	===========================================================================

#ifdef WIN32
	#ifndef STRICT
		#define STRICT
	#endif
	#ifndef WIN32_LEAN_AND_MEAN
		#define WIN32_LEAN_AND_MEAN
	#endif

	/**
	 * @def FORCEINLINE
	 * Forces a section inline
	 */
	#define FORCEINLINE __forceinline

	/**
	 * @def ALWAYS_INLINE
	 * Does nothing on winodws, must follow function decl' on mac for inline functions
	 */
	#define ALWAYS_INLINE

	/**
	 * @typedef uint64
	 * @brief typedef to an unsigned long long
	 */
	typedef unsigned __int64 uint64;

#else

	/**
	 * @typedef uint64
	 * @brief typedef to an unsigned long long
	 */
	typedef unsigned long long uint64;

	/**
	 * @def _cdecl
	 * Empty Mac version of cdecl
	 */
	#ifndef _cdecl
		#define _cdecl
	#endif

	/**
	 * @def _MAX_PATH
	 * Max path for max, to have equivalent to windows
	 */
	#ifndef _MAX_PATH
		#define _MAX_PATH 260
	#endif

	/**
	 * @cond
	 */
	#ifndef __USE_BSD
		#define __USE_BSD
	#endif
	/**
	 * @endcond
	 */

	/**
	 * @def interface
	 * Defines an 'interface' style class. Classes declared in this way *should have* only pure virtual functions. However this is not enforced on either platform
	 */
	#define interface class

	/**
	 * @def FORCEINLINE
	 * Forces a section inline
	 */
	#define FORCEINLINE inline

	/**
	 * @def ALWAYS_INLINE
	 * Does nothing on winodws, must follow function decl' on mac for inline functions
	 */
	#define ALWAYS_INLINE __attribute__((always_inline))

	/**
	 * @cond
	 */
	#define stricmp strcasecmp
	/**
	 * @endcond
	 */
#endif

#endif	// End of StdDefines.h